Public Class Password
  Private Structure Security
    Dim User As String              ' A list of the users for this program
    Dim Pass As String              ' The password
    Dim SecurityLevel As Integer    ' Each user has a security level
  End Structure
  Private UserCount As Integer      ' How many users

  Private UserList() As Security

  Public Sub New()
    InitUserList()
  End Sub

  Private Sub InitUserList()
    ReDim UserList(100)
    With UserList(0)
      .User = "Debbie Plesluska"
      .Pass = "Cubic"
      .SecurityLevel = 8
    End With
    With UserList(1)
      .User = "Jay Crannel"
      .Pass = "Whiff"
      .SecurityLevel = 8
    End With
    With UserList(2)
      .User = "Jim McAllister"
      .Pass = "Slice"
      .SecurityLevel = 6
    End With
    With UserList(3)
      .User = "Jack"
      .Pass = "Jocye4"
      .SecurityLevel = 10
    End With
 
  End Sub


  Public Function SetPassword(ByVal Password As String, ByVal User As String) As Integer
    '=====
    ' Code writer: Dr. Purdum, PUC
    '
    ' Purpose   This function is used to encode the password string entered
    '           by the user. It does this by adding two numeric characters
    '           to the front of the sting followed by the password charac-
    '           ters themselves. Each character is calculated as the char-
    '           acter modulo 26 plus the length of the password.
    '
    ' Argument list:
    '   Password          A string that contains the password
    '   User              The name of the user
    '
    ' Return Value:
    '   integer           True if set OK; False otherwise
    '
    '=====    
    Dim Check As Integer
    Dim EncodedPassword As String

    Check = CreateChecksum(User)
    EncodedPassword = EncodePassword(Password, Check)

  End Function

  Public Function GetPassword(ByVal User As String, ByVal Password As String) As Integer

    '=====
    ' Code writer: Dr. Purdum, PUC
    '
    ' Purpose   This routine is used to check for a password match for a
    '           user.
    '
    ' Argument list:
    '   User          The user for this password
    '   Password      A string that contains the password
    '
    ' Return Value:
    '   integer       True if set if the correct password is given,
    '                 False otherwise
    '
    '=====   
    Dim Check As Integer
    Dim EncodedPW As String, DecodedPW As String
    Dim Temp As String, OriginalPW As String

    OriginalPW = Password
    Check = CreateChecksum(User)
    EncodedPW = EncodePassword(Password, Check)

    Temp = DecodePassword(EncodedPW, Check)

    If Temp = UCase(OriginalPW) Then
      Return True     ' Match
    Else
      Return False    ' No match
    End If

  End Function


  Private Function CreateChecksum(ByVal User As String) As Integer
    '=====
    ' Code writer: Dr. Purdum, PUC
    '
    ' Purpose   This routine is used to create a checksum for a password.
    '
    ' Argument list:
    '   User          The user name for this password
    '
    ' Return Value:
    '   integer       The checksum
    '
    '=====
    Dim i As Integer, sum As Long

    sum = 0
    For i = 1 To Len(User)
      sum = sum + Asc(Mid$(User, i, 1))
    Next i
    i = sum Mod 26

    If i = 0 Then i = 1 ' Don't want to use zero
    CreateChecksum = i

  End Function


  Private Function DecodePassword(ByVal p As String, ByVal Check As Integer) As String
    Dim i As Integer, Temp As Integer
    Dim length As Integer
    Dim s As String, w As String

    For i = 1 To 4
      'Mid(s, i, 1) = Chr(Asc(Mid(p, i, 1)) - 26)
      s &= Chr(Asc(Mid(p, i, 1)) - 26)
   Next i
    length = Val(Mid(s, 1, 2))
    Check = Val(Mid(s, 3, 2))

    For i = 5 To length + 4
      w = w + Chr(Asc(Mid(p, i, 1)) - Check)
    Next i
    DecodePassword = w

  End Function


  Private Function EncodePassword(ByVal Pass As String, ByVal Check As Integer) As String
    ' Purpose:  This routine is used to encode the password string entered
    '           by the user. It does this by adding two numeric characters
    '           to the front of the sting followed by the password charac-
    '           ters themselves. Each character is calculated as the char-
    '           acter modulo 26 plus the length of the password.
    '
    ' Parameters:
    '   Pass      the password to encode
    '   Check     the checksum for the password
    '
    ' Return value:
    '   string    the encoded password
    '
    Dim s As String, cs As String, d As String, buff As String
    Dim Temp As Integer, i As Integer, length As Integer

    d = Format$(Len(Pass), "00")
    s = Format$(Check, "00")
    buff = d & s

    For i = 1 To 4
      Temp = Asc(Mid$(buff, i, 1)) + 26
      Mid$(buff, i, 1) = Chr(Temp)
    Next i

    d = ""
    For i = 1 To Len(Pass)
      Temp = Asc(Mid$(Pass, i, 1)) + Check
      d = d + Chr(Temp)
    Next i

    s = d
    Randomize()
    For i = Len(d) + 1 To 26
      Temp = 0
      Do While Temp < 32 Or Temp > 127
        Temp = Rnd() * 127
      Loop
      s = s & Chr(Temp)
    Next i

    Pass = buff & s
    EncodePassword = Pass

  End Function


End Class
